/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */
package teamdev.jxcapture.samples.demo;

import java.io.*;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.HashMap;

/**
 * @author Ikryanov Vladimir
 */
public class ApplicationSettings {

    private static final String CAPTURE_TO_FILE = "CAPTURE_TO_FILE";
    private static final String CAPTURE_TO_VIEWER = "CAPTURE_TO_VIEWER";
    private static final String CAPTURE_TO_CLIPBOARD = "CAPTURE_TO_CLIPBOARD";
    private static final String INCLUDE_CURSOR = "INCLUDE_CURSOR";
    private static final String CAPTURE_TRANSPARENT_WINDOWS = "CAPTURE_TRANSPARENT_WINDOWS";
    private static final String DELAY_BEFORE_CAPTURE = "DELAY_BEFORE_CAPTURE";
    private static final String AUTO_SAVE = "AUTO_SAVE";
    private static final String DELAY_TIME = "DELAY_TIME";
    private static final String TEMPLATE_FILE_NAME = "TEMPLATE_FILE_NAME";
    private static final String OUTPUT_FOLDER = "OUTPUT_FOLDER";
    private static final String IMAGE_FORMAT_INDEX = "IMAGE_FORMAT_INDEX";
    private static final String TEMPLATE_NUMBER = "TEMPLATE_NUMBER";

    private static ApplicationSettings instance;
    private static ResourceBundle resource;

    private int maxDelayTime = 60000;
    private String[] imageFormats = new String[] {"png", "jpeg", "bmp", "gif"};
    private Map imageFormatExtensions = new HashMap();
    private String[] formatDescriptions = new String[] {"PNG Graphic (*.png)", "JPEG Graphic (*.jpeg, *.jpg)", "BMP Graphic (*.bmp)", "GIF Graphic (*.gif)"};
    private String configFileName = "appconfig.conf";

    private boolean captureToViewer = true;
    private boolean captureToFile;
    private boolean captureToClipboard;
    private boolean includeCursor;
    private boolean captureTransparentWindows;
    private boolean delayBeforeCapture;
    private boolean autoSave;

    private String templateFileName = "ScreenShot#";
    private String outputFolder = "";

    private int delayTime = 1000;
    private int imageFormatIndex;
    private int templateNumber;

    private ApplicationSettings() {
        imageFormatExtensions.put(imageFormats[0], new String[] {"png", "PNG"});
        imageFormatExtensions.put(imageFormats[1], new String[] {"jpeg", "JPEG", "jpg", "JPG"});
        imageFormatExtensions.put(imageFormats[2], new String[] {"bmp", "BMP"});
        imageFormatExtensions.put(imageFormats[3], new String[] {"gif", "GIF"});
    }

    public static ApplicationSettings getInstance() {
        return instance == null ? instance = new ApplicationSettings() : instance;
    }

    public static ResourceBundle getResourceBundle() {
        if (resource == null) {
            resource = ResourceBundle.getBundle("teamdev.jxcapture.samples.demo.resources.JxCaptureDemo");
        }
        return resource;
    }

    public void saveSettings() {
        Properties properties = new Properties();

        properties.setProperty(CAPTURE_TO_FILE, String.valueOf(captureToFile));
        properties.setProperty(CAPTURE_TO_VIEWER, String.valueOf(captureToViewer));
        properties.setProperty(CAPTURE_TO_CLIPBOARD, String.valueOf(captureToClipboard));
        properties.setProperty(INCLUDE_CURSOR, String.valueOf(includeCursor));
        properties.setProperty(CAPTURE_TRANSPARENT_WINDOWS, String.valueOf(captureTransparentWindows));
        properties.setProperty(DELAY_BEFORE_CAPTURE, String.valueOf(delayBeforeCapture));
        properties.setProperty(AUTO_SAVE, String.valueOf(autoSave));

        properties.setProperty(TEMPLATE_FILE_NAME, templateFileName);
        properties.setProperty(OUTPUT_FOLDER, outputFolder);

        properties.setProperty(DELAY_TIME, String.valueOf(delayTime));
        properties.setProperty(IMAGE_FORMAT_INDEX, String.valueOf(imageFormatIndex));
        properties.setProperty(TEMPLATE_NUMBER, String.valueOf(templateNumber));

        try {
            File configFile = new File(configFileName);
            OutputStream outputStream = new FileOutputStream(configFile);
            properties.store(outputStream, "JxCapture Demo Application Settings");
            outputStream.flush();
            outputStream.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadSettings() {
        Properties properties = new Properties();
        try {
            File configFile = new File(configFileName);
            if (!configFile.exists()) return;
            InputStream inputStream = new FileInputStream(configFile);
            properties.load(inputStream);
            inputStream.close();
        } catch (Exception e) {
            e.printStackTrace();
            return;
        }

        captureToFile = Boolean.valueOf(properties.getProperty(CAPTURE_TO_FILE)).booleanValue();
        captureToViewer = Boolean.valueOf(properties.getProperty(CAPTURE_TO_VIEWER)).booleanValue();
        captureToClipboard = Boolean.valueOf(properties.getProperty(CAPTURE_TO_CLIPBOARD)).booleanValue();
        includeCursor = Boolean.valueOf(properties.getProperty(INCLUDE_CURSOR)).booleanValue();
        captureTransparentWindows = Boolean.valueOf(properties.getProperty(CAPTURE_TRANSPARENT_WINDOWS)).booleanValue();
        delayBeforeCapture = Boolean.valueOf(properties.getProperty(DELAY_BEFORE_CAPTURE)).booleanValue();
        autoSave = Boolean.valueOf(properties.getProperty(AUTO_SAVE)).booleanValue();

        templateFileName = properties.getProperty(TEMPLATE_FILE_NAME);
        outputFolder = properties.getProperty(OUTPUT_FOLDER);

        delayTime = Integer.valueOf(properties.getProperty(DELAY_TIME)).intValue();
        imageFormatIndex = Integer.valueOf(properties.getProperty(IMAGE_FORMAT_INDEX)).intValue();
        templateNumber = Integer.valueOf(properties.getProperty(TEMPLATE_NUMBER)).intValue();
    }

    public boolean isIncludeCursor() {
        return includeCursor;
    }

    public void setIncludeCursor(boolean includeCursor) {
        this.includeCursor = includeCursor;
    }

    public boolean isCaptureTransparentWindows() {
        return captureTransparentWindows;
    }

    public void setCaptureTransparentWindows(boolean captureTransparentWindows) {
        this.captureTransparentWindows = captureTransparentWindows;
    }

    public boolean isDelayBeforeCapture() {
        return delayBeforeCapture;
    }

    public void setDelayBeforeCapture(boolean delayBeforeCapture) {
        this.delayBeforeCapture = delayBeforeCapture;
    }

    public boolean isAutoSave() {
        return autoSave;
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    public int getDelayTime() {
        return delayTime;
    }

    public void setDelayTime(int delayTime) {
        this.delayTime = delayTime;
    }

    public int getImageFormatIndex() {
        return imageFormatIndex;
    }

    public void setImageFormatIndex(int imageFormatIndex) {
        this.imageFormatIndex = imageFormatIndex;
    }

    public int getTemplateNumber() {
        return templateNumber;
    }

    public void setTemplateNumber(int templateNumber) {
        this.templateNumber = templateNumber;
    }

    public String getOutputFolder() {
        return outputFolder;
    }

    public void setOutputFolder(String outputFolder) {
        this.outputFolder = outputFolder;
    }

    public String getTemplateFileName() {
        return templateFileName;
    }

    public void setTemplateFileName(String templateFileName) {
        this.templateFileName = templateFileName;
    }

    public boolean isCaptureToViewer() {
        return captureToViewer;
    }

    public void setCaptureToViewer() {
        resetCaptureToValues();
        captureToViewer = true;
    }

    public boolean isCaptureToFile() {
        return captureToFile;
    }

    public void setCaptureToFile() {
        resetCaptureToValues();
        captureToFile = true;
    }

    public boolean isCaptureToClipboard() {
        return captureToClipboard;
    }

    public void setCaptureToClipboard() {
        resetCaptureToValues();
        captureToClipboard = true;
    }

    public String[] getImageFormats() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.4")) return new String[] {imageFormats[0], imageFormats[1]};
        if (version.startsWith("1.5")) return new String[] {imageFormats[0], imageFormats[1], imageFormats[2]};
        return imageFormats;
    }

    public String[] getFormatDescriptions() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.4")) return new String[] {formatDescriptions[0], formatDescriptions[1]};
        if (version.startsWith("1.5")) return new String[] {formatDescriptions[0], formatDescriptions[1], formatDescriptions[2]};
        return formatDescriptions;
    }

    public String[] getFormatExtensions(String imageFormat) {
        Object result = imageFormatExtensions.get(imageFormat);
        if (result == null) return new String[0];
        return (String[]) result;
    }

    public int getMaxDelayTime() {
        return maxDelayTime;
    }

    private void resetCaptureToValues() {
        captureToViewer = false;
        captureToFile = false;
        captureToClipboard = false;
    }
}

